//
//  IHRBLEManager.h
//
//

#import <Foundation/Foundation.h>
#import <CoreBluetooth/CoreBluetooth.h>

typedef void (^IHRBLEManagerReceiveCallBackBlock)(CBCharacteristic *characteristic);

@protocol IHRBLEManagerDelegate <NSObject>
@optional
/**
 *  found peripheral list
 */
- (void)IHRbleUpdatePeripheralList:(NSArray *)peripherals RSSIList:(NSArray *)rssiList;
/**
 *  connect success
 */
- (void)IHRbleConnectPeripheral:(CBPeripheral *)peripheral;
/**
 *  connect fail
 */
- (void)IHRbleFailToConnectPeripheral:(CBPeripheral *)peripheral error:(NSError *)error;
/**
 *  disconnect
 */
- (void)IHRbleDisconnectPeripheral:(CBPeripheral *)peripheral;
/**
 *  send data success
 */
- (void)IHRbleWriteValueForCharacteristic:(CBCharacteristic *)character error:(NSError *)error;
/**
 *  receive printer data
 */
- (void)IHRbleReceiveValueForCharacteristic:(CBCharacteristic *)characteristic error:(NSError *)error;
@end

@interface IHRBLEManager : NSObject

@property (nonatomic,weak) id<IHRBLEManagerDelegate> delegate;

//peripheral that write
@property (nonatomic,strong) CBPeripheral *writePeripheral;

@property (nonatomic, copy) IHRBLEManagerReceiveCallBackBlock receiveBlock;

//whether connect
@property (nonatomic, assign) BOOL isConnect;

/**
 *  singleton
 */
+ (instancetype)sharedInstance;
/**
 *  start scan
 */
- (void)startScan;
/**
 *  stop scan
 */
- (void)stopScan;
/**
 *  connect special one
 */
- (void)connectDevice:(CBPeripheral *)peripheral;
/**
 *  disconnect manual
 */
- (void)disconnectRootPeripheral;
/**
 *  send command
 */
- (void)writeCommandWithData:(NSData *)data;
/**
 *  remove a delegate
 */
- (void)removeDelegate:(id<IHRBLEManagerDelegate>)delegate;
/**
 *  remove all delegates
 */
- (void)removeAllDelegates;
/**
 * query printer data
 */
- (void)getPrinterData:(IHRBLEManagerReceiveCallBackBlock)receiveBlock;

@end
